require "prefabutil"

local assets=
{
    --Asset("ANIM", "anim/dust_fx.zip"),
	Asset("ANIM", "anim/emcsolar.zip"),
    Asset("SOUND", "sound/forest.fsb"),
}


local function DoIdle(inst)
	local EMC = 3000*2/(480/inst.idletime)
	if inst.EMCboosted == true then
		EMC = EMC*5
		inst.EMCboosted = false
	end
	
	inst.components.EMCglobalbuffer:AddInt(EMC)
	inst.components.EMCglobalbuffer:AddToGlobal(EMC*2)
	
end

local function StopIdling(inst)
    if inst.idletask then
        inst.idletask:Cancel()
        inst.idletask = nil
    end
end

local function StartIdling(inst)	
	if not inst.idletask then
		inst.idletime = 0.8+math.random()*0.4
		inst.idletask = inst:DoPeriodicTask(inst.idletime, DoIdle)
	end
end


local function onhammered(inst, worker)
	--inst.components.lootdropper:DropLoot()
	--inst.components.container:DropEverything()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")	
	inst:Remove()
end

local function onhit(inst, worker)
	--inst.AnimState:PlayAnimation("hit")
	--inst.components.container:DropEverything()
	--inst.AnimState:PushAnimation("closed", false)
	--inst.components.container:Close()
end

local function onbuilt(inst)
	local anim = inst.AnimState
	anim:SetBank("emcsolar")
	anim:SetBuild("emcsolar")
	anim:PlayAnimation("grow")
	anim:PushAnimation("idle", true)
end




local function OnSave(inst, data)
    --if inst.EEupgraded and inst.EEupgraded == true then
        --data["EEUpGr"] = "yes"
    --end
end

local function OnLoad(inst, data)
    --[[if data and data["EEUpGr"] then
		--print("EEUpGr:"..data["EEUpGr"])
		inst.EEupgraded = true
	else
		print("no EEupgraded")
		inst.EEupgraded = false
	end--]]
end
		
local function init()
	local fn = function(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddSoundEmitter()
		--local minimap = inst.entity:AddMiniMapEntity()
		
		--minimap:SetIcon( "birdcage.png" )


		inst:AddTag("structure")
		local anim = inst.AnimState
		anim:SetBank("emcsolar")
		anim:SetBuild("emcsolar")
		anim:PlayAnimation("idle",true)
		
		
		inst:AddComponent("inspectable")
		
		--inst:AddComponent("lootdropper")
		inst:AddComponent("workable")
		inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
		inst.components.workable:SetWorkLeft(2)
		inst.components.workable:SetOnFinishCallback(onhammered)
		inst.components.workable:SetOnWorkCallback(onhit) 
		
		
		inst:ListenForEvent( "onbuilt", onbuilt)
		MakeSnowCovered(inst, .01)
		
		local light = inst.entity:AddLight()
		light:SetIntensity(0.3)
		light:SetRadius(2)
		light:SetColour(1/255, 1/255, 255/255)
		light:Enable(true)
		
		inst.EMCboosted = false
		inst:AddTag("EMCsolar")
		inst:AddComponent("EMCglobalbuffer")
		inst.components.EMCglobalbuffer.maxEMC = 3000
		StartIdling(inst)
		
		inst.OnSave = OnSave
		inst.OnLoad = OnLoad
	
		return inst
	end
	return fn
end



return	Prefab( "common/prefab/emcsolar", init(), assets),
		MakePlacer("common/prefab/emcsolar_placer", "emcsolar", "emcsolar", "IDLE")


		
		
		